<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(["status" => false, "message" => "Only GET requests are allowed."]);
    exit;
}

require_once 'db.php';
require_once 'function.php';

// Get pagination parameters
$page  = isset($_GET['page'])  ? max(1, intval($_GET['page']))  : 1;
$limit = isset($_GET['limit']) ? max(1, intval($_GET['limit'])) : 10;
$offset = ($page - 1) * $limit;

// Optional: filter by feed_id
$feed_id = $_GET['feed_id'] ?? null;

// Base SQL
$sql = "SELECT 
            fc.comment_id, 
            fc.feed_id, 
            fc.contents, 
            fc.status, 
            fc.created_at, 
            u.user_id, 
            u.name, 
            u.userName, 
            u.profile_url
        FROM feed_comments fc
        JOIN users u ON fc.user_id = u.user_id";

$params = [];
if ($feed_id) {
    $sql .= " WHERE fc.feed_id = ?";
    $params[] = $feed_id;
}

// Append LIMIT and OFFSET directly (not as bound parameters)
$sql .= " ORDER BY fc.created_at DESC LIMIT $limit OFFSET $offset";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$comments = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get total count for pagination
$countSql = "SELECT COUNT(*) FROM feed_comments";
$countParams = [];

if ($feed_id) {
    $countSql .= " WHERE feed_id = ?";
    $countParams[] = $feed_id;
}

$countStmt = $pdo->prepare($countSql);
$countStmt->execute($countParams);
$total_comments = $countStmt->fetchColumn();
$total_pages = ceil($total_comments / $limit);

if ($comments) {
    echo json_encode([
        "status" => "success",
        "page" => $page,
        "limit" => $limit,
        "total_pages" => $total_pages,
        "total_comments" => $total_comments,
        "data" => $comments
    ]);
} else {
    http_response_code(404);
    echo json_encode([
        "status" => "error",
        "message" => "No comments found"
    ]);
}
