<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
require_once 'db.php';
require_once 'castHelper.php'; 
// Get pagination parameters
$page  = isset($_GET['page']) && is_numeric($_GET['page']) ? (int) $_GET['page'] : 1;
$limit = isset($_GET['limit']) && is_numeric($_GET['limit']) ? (int) $_GET['limit'] : 10;
$offset = ($page - 1) * $limit;
try {
    // Step 1: Get total count of course categories
    $countQuery = "SELECT COUNT(*) AS total FROM course_category WHERE status = 1";
    $countStmt = $pdo->prepare($countQuery);
    $countStmt->execute();
    $total = $countStmt->fetch(PDO::FETCH_ASSOC)['total'];

    // Step 2: Fetch paginated course categories
    $categoryQuery = "SELECT * FROM course_category WHERE status = 1 ORDER BY updated_at DESC LIMIT :limit OFFSET :offset";
    $categoryStmt = $pdo->prepare($categoryQuery);
    $categoryStmt->bindParam(':limit', $limit, PDO::PARAM_INT);
    $categoryStmt->bindParam(':offset', $offset, PDO::PARAM_INT);
    $categoryStmt->execute();
    $categories = $categoryStmt->fetchAll(PDO::FETCH_ASSOC);

    $finalResult = [];
    // Step 3: For each category, fetch related courses
   foreach ($categories as $category) {
    $c_category_id = $category['c_category_id'];
    // $courseQuery = "
    //     SELECT 
    //         c.*, 
    //         COUNT(DISTINCT fc.comment_id) AS total_comments, 
    //         COUNT(DISTINCT l.like_id) AS total_likes
    //     FROM courses c
    //     LEFT JOIN feed_comments fc ON fc.feed_id = c.course_id
    //     LEFT JOIN likes l ON l.post_id = c.course_id
    //     WHERE c.c_category_id = :c_category_id
    //     GROUP BY c.course_id
    // ";
    $courseQuery = "
    SELECT 
        c.*, 
        IFNULL(sc.title, 'None') AS subject_title,
        COUNT(DISTINCT fc.comment_id) AS total_comments, 
        COUNT(DISTINCT l.like_id) AS total_likes
    FROM courses c
    LEFT JOIN feed_comments fc ON fc.feed_id = c.course_id
    LEFT JOIN likes l ON l.post_id = c.course_id
    LEFT JOIN subject_category sc ON sc.sc_id = c.subject_cid
    WHERE c.c_category_id = :c_category_id
    GROUP BY c.course_id
";
    $courseStmt = $pdo->prepare($courseQuery);
    $courseStmt->bindParam(':c_category_id', $c_category_id);
    $courseStmt->execute();
    $courses = $courseStmt->fetchAll(PDO::FETCH_ASSOC);

    $category['courses'] = $courses;
    $category = array_map('castTypes', $category);
    $finalResult[] = $category;
}
    // Step 4: Return structured response
    echo json_encode([
        "status" => "success",
        "page" => $page,
        "limit" => $limit,
        "total" => (int)$total,
        "pages" => ceil($total / $limit),
        "data" => $finalResult
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "Database error: " . $e->getMessage()
    ]);
}
?>
