<?php
// Include database connection
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
require_once 'db.php'; // Include DB connection
require_once 'function.php'; // Include Function

// Function to generate course_id

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if all required fields are present in the POST request
    if (
        !empty($_POST['fac_id'])
        // !empty($_POST['title']) &&
        // !empty($_POST['c_category_id']) &&
        // !empty($_POST['type']) &&
        // !empty($_POST['price']) &&
        // !empty($_POST['status'])
    ) {
        $filePath = null; // Default value for fileurls

        // Check if a file is uploaded
        if (isset($_FILES['fileurls']) && $_FILES['fileurls']['error'] === UPLOAD_ERR_OK) {
            // Handle file upload
            $targetDir = "uploads/"; // Directory to store uploaded files
            $fileName = basename($_FILES['fileurls']['name']);
            $targetFilePath = $targetDir . $fileName;

            // Check if the directory exists, if not, create it
            if (!is_dir($targetDir)) {
                mkdir($targetDir, 0777, true);
            }

            // Move the uploaded file to the target directory
            if (move_uploaded_file($_FILES['fileurls']['tmp_name'], $targetFilePath)) {
                $filePath = $targetFilePath; // Set the file path
            } 
        }

        // Generate course_id
        $course_id = uniqid('COU_');

        // Prepare the SQL query
        $query = "INSERT INTO `courses`(`course_id`, `fac_id`, `semester_id`,`subject_cid`, `title`, `c_category_id`, `type`, `price`, `fileurls`, `status`, `created_at`, `updated_at`) 
                  VALUES (:course_id, :fac_id, :semester_id,:subject_id, :title, :c_category_id, :type, :price, :fileurls, :status, NOW(), NOW())";

        $stmt = $pdo->prepare($query);

        // Bind parameters
        $stmt->bindParam(':course_id', $course_id);
        $stmt->bindParam(':fac_id', $_POST['fac_id']);
        $stmt->bindParam(':semester_id', $_POST['semester_id']);
        $stmt->bindParam(':subject_id', $_POST['subject_id']);
        $stmt->bindParam(':title', $_POST['title']);
        $stmt->bindParam(':c_category_id', $_POST['c_category_id']);
        $stmt->bindParam(':type', $_POST['type']);
        $stmt->bindParam(':price', $_POST['price']);
        $stmt->bindParam(':fileurls', $filePath); // Bind the file path or NULL
        $stmt->bindParam(':status', $_POST['status']);

        // Execute the query
        if ($stmt->execute()) {
            echo json_encode(["message" => "Course was created successfully."]);
        } else {
            http_response_code(503);
            echo json_encode(["message" => "Unable to create course."]);
        }
    } else {
        http_response_code(400);
        echo json_encode(["message" => "Incomplete data."]);
    }
} else {
    http_response_code(405);
    echo json_encode(["message" => "Invalid request method. Only POST is allowed."]);
}
