<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["error" => "Invalid request method. Only POST is allowed."]);
    exit;
}

require_once 'db.php'; // Include DB connection
require_once 'function.php'; // Include Function

// Validate required fields
if ( empty($_POST['title']) ||
    empty($_POST['contents']) ||
    empty($_POST['status'])
) {
    echo json_encode(["error" => "All fields are required."]);
    exit;
}

// Prepare faculty data
$fac_id = uniqid('FAC_');
$title = htmlspecialchars($_POST['title']);
$contents = htmlspecialchars($_POST['contents']);
$status = htmlspecialchars($_POST['status']);
$created_at = date('Y-m-d H:i:s');
$update_at = date('Y-m-d H:i:s');

$sql = "INSERT INTO faculty (fac_id, title, contents, status, created_at, update_at)
        VALUES (?, ?, ?, ?, ?, ?)";
$stmt = $pdo->prepare($sql);

try {
    if ($stmt->execute([$fac_id, $title, $contents, $status, $created_at, $update_at])) {
        if ($stmt->rowCount() > 0) {
            echo json_encode([
                "status" => 'success',
                "message" => "Record inserted successfully."
            ]);
        } else {
            echo json_encode(["error" => "Failed to insert record."]);
        }
    } else {
        echo json_encode(["error" => "Something went wrong while inserting the record."]);
    }
} catch (PDOException $e) {
    echo json_encode(["error" => "Failed to insert record."]);
}
?>