<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Headers: Content-Type");
require_once 'db.php'; // Your PDO database connection (returns $pdo)

// Upload directory
$uploadDir = "FeedImage/";
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

// POST inputs
$user_id = $_POST['user_id'] ?? '';
$caption = $_POST['caption'] ?? 'This is a default caption';
$comment_allow = $_POST['comment_allow'] ?? 'public';
$feed_privacy = $_POST['feed_privacy'] ?? 'public';
$education_type = $_POST['education_type'] ?? 'all';
$device_name = $_POST['device_name'] ?? 'all';

$location_id = $_POST['location_id'] ?? '02356';
$post_device = $_POST['post_device'] ?? 'mobile';
$longitude = $_POST['longitude'] ?? '02136';
$latitude = $_POST['latitude'] ?? '895623';
$location_type = $_POST['type'] ?? 'manual';

// Validate required
if (empty($user_id) || empty($caption)) {
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields']);
    exit;
}

// Upload images
$uploaded_files = [];
$datetime = date('Ymd_His');

$uploaded_files = [];
$datetime = date('Ymd_His');

if (isset($_FILES['images'])) {
    // Normalize: convert single file to array
    $fileCount = is_array($_FILES['images']['name']) ? count($_FILES['images']['name']) : 1;

    for ($i = 0; $i < $fileCount; $i++) {
        $name = is_array($_FILES['images']['name']) ? $_FILES['images']['name'][$i] : $_FILES['images']['name'];
        $tmpName = is_array($_FILES['images']['tmp_name']) ? $_FILES['images']['tmp_name'][$i] : $_FILES['images']['tmp_name'];

        $ext = pathinfo($name, PATHINFO_EXTENSION);
        $fileName = "feed_" . $datetime . "_" . uniqid() . "." . $ext;
        $targetPath = $uploadDir . $fileName;

        if (move_uploaded_file($tmpName, $targetPath)) {
            $uploaded_files[] = $fileName;
        }
    }
}
try {
    // Start transaction
    $pdo->beginTransaction();

    // Feed ID
    $feed_id = uniqid('feed_');
    $category_id = 0;
    $status = 'public';
    $created_at = date('Y-m-d H:i:s');
    $updated_at = $created_at;

    // Insert into feeds
    $stmt = $pdo->prepare("INSERT INTO feeds 
        (feed_id, user_id, contents, category_id, commentStatus, education_type, feed_privacy, status, created_at, updated_at)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    $stmt->execute([
        $feed_id,
        $user_id,
        $caption,
        $category_id,
        $comment_allow,
        $education_type,
        $feed_privacy,
        $status,
        $created_at,
        $updated_at
    ]);

    // Insert into feed_location
    $locationStmt = $pdo->prepare("INSERT INTO feed_location 
        (location_id, feed_id, post_device, longitude, latitude, type, created_at) 
        VALUES (?, ?, ?, ?, ?, ?, ?)");

    $locationStmt->execute([
        $location_id,
        $feed_id,
        $post_device,
        $longitude,
        $latitude,
        $location_type,
        $created_at
    ]);

    // Insert each file URL into feed_url
    $urlStmt = $pdo->prepare("INSERT INTO feed_url 
        (feed_url_id, feed_id, url_type, urls, status, created_at) 
        VALUES (?, ?, ?, ?, ?, ?)");

    foreach ($uploaded_files as $file) {
        $feed_url_id = uniqid('url_');
        $url_type = 'image';
        $url = $uploadDir . $file;
        $url_status = 'active';

        $urlStmt->execute([
            $feed_url_id,
            $feed_id,
            $url_type,
            $url,
            $url_status,
            $created_at
        ]);
    }

    // Commit transaction
    $pdo->commit();

    echo json_encode([
        'status' => 'success',
        'message' => 'Feed, location and image URLs uploaded successfully',
        'feed_id' => $feed_id,
        'device_name' => $device_name,
       
    ]);

} catch (Exception $e) {
    $pdo->rollBack();
    echo json_encode([
        'status' => 'error',
        'message' => 'Something went wrong: ' . $e->getMessage()
    ]);
}
?>
