<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
require_once 'db.php';
require_once 'function.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_POST['user_id'] ?? null;
    $contents = $_POST['contents'] ?? null;
    $category_id = $_POST['category_id'] ?? null;
    $commentStatus = $_POST['commentStatus'] ?? null;
    $status = $_POST['status'] ?? 'private';
    $post_device = $_POST['post_device'] ?? null;
    $longitude = $_POST['longitude'] ?? null;
    $latitude = $_POST['latitude'] ?? null;
    // $type = $_POST['type'] ?? 'Post';

    if ($user_id && $contents && $category_id && $commentStatus && $status && $post_device && $longitude && $latitude && $type) {
        $feed_id = generateFeedId($pdo);
        $location_id = generateLocationId($pdo);
        $created_at = date('Y-m-d H:i:s');
        $updated_at = date('Y-m-d H:i:s');

        $sql = "INSERT INTO `feeds`(`feed_id`, `user_id`, `contents`, `category_id`, `commentStatus`, `status`, `created_at`, `updated_at`) 
                VALUES (:feed_id, :user_id, :contents, :category_id, :commentStatus, :status, :created_at, :updated_at)";
        $stmt = $pdo->prepare($sql);

        try {
            $pdo->beginTransaction();

            $stmt->execute([
                ':feed_id' => $feed_id,
                ':user_id' => $user_id,
                ':contents' => $contents,
                ':category_id' => $category_id,
                ':commentStatus' => $commentStatus,
                ':status' => $status,
                ':created_at' => $created_at,
                ':updated_at' => $updated_at,
            ]);

            $sql_location = "INSERT INTO `feed_location`(`location_id`, `feed_id`, `post_device`, `longitude`, `latitude`, `type`, `created_at`) 
                             VALUES (:location_id, :feed_id, :post_device, :longitude, :latitude, :type, :created_at)";
            $stmt_location = $pdo->prepare($sql_location);

            $stmt_location->execute([
                ':location_id' => $location_id,
                ':feed_id' => $feed_id,
                ':post_device' => $post_device,
                ':longitude' => $longitude,
                ':latitude' => $latitude,
                ':type' => $type,
                ':created_at' => $created_at,
            ]);

            // Handle multiple image uploads
            if (isset($_FILES['image']) && is_array($_FILES['image']['name'])) {
                $fileCount = count($_FILES['image']['name']);
                for ($i = 0; $i < $fileCount; $i++) {
                    if ($_FILES['image']['error'][$i] === UPLOAD_ERR_OK) {
                        $uploadDir = 'feedImage/';
                        if (!is_dir($uploadDir)) {
                            mkdir($uploadDir, 0777, true);
                        }
                        $fileName = basename($_FILES['image']['name'][$i]);
                        $targetFilePath = $uploadDir . uniqid() . '_' . $fileName;

                        if (move_uploaded_file($_FILES['image']['tmp_name'][$i], $targetFilePath)) {
                            $feed_url_id = generateFeedUrlId($pdo);
                            $sql_feed_url = "INSERT INTO `feed_url`(`id`, `feed_url_id`, `feed_id`, `url_type`, `urls`, `status`, `created_at`) 
                                             VALUES (NULL, :feed_url_id, :feed_id, :url_type, :urls, :status, :created_at)";
                            $stmt_feed_url = $pdo->prepare($sql_feed_url);

                            $stmt_feed_url->execute([
                                ':feed_url_id' => $feed_url_id,
                                ':feed_id' => $feed_id,
                                ':url_type' => 'image',
                                ':urls' => $targetFilePath,
                                ':status' => $status,
                                ':created_at' => $created_at,
                            ]);
                        }
                    }
                }
            }

            $pdo->commit();

            echo json_encode(['success' => true, 'message' => 'Feed, location, and URLs created successfully', 'feed_id' => $feed_id, 'location_id' => $location_id]);
        } catch (Exception $e) {
            $pdo->rollBack();
            echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'All fields are required']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>
