<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Headers: Content-Type");
header("Access-Control-Allow-Origin: *");
require_once 'db.php'; // PDO connection
require_once 'castHelper.php'; 
try {
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Only GET method is allowed"]);
        exit;
    }

    // Pagination
    $page = isset($_GET['page']) && $_GET['page'] > 0 ? (int)$_GET['page'] : 1;
    $limit = isset($_GET['limit']) && $_GET['limit'] > 0 ? (int)$_GET['limit'] : 5;
    $offset = ($page - 1) * $limit;

    // Total count
    $count_sql = "SELECT COUNT(*) as total FROM reels";
    $count_stmt = $pdo->query($count_sql);
    $total = $count_stmt->fetch(PDO::FETCH_ASSOC)['total'];

    // Main reels query (all users)
    $sql = "SELECT f.*, u.name, u.userName, u.profile_url
            FROM reels f
            LEFT JOIN users u ON u.user_id = f.user_id
            ORDER BY f.id DESC
            LIMIT :limit OFFSET :offset";

    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $data = [];

        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $feed_id = $row['reels_id'];

            // Get comments
            $comments_stmt = $pdo->prepare("SELECT * FROM feed_comments WHERE feed_id = :feed_id");
            $comments_stmt->execute(['feed_id' => $feed_id]);
            $comments = $comments_stmt->fetchAll(PDO::FETCH_ASSOC);
            $row['total_comments'] = count($comments);

            // Get total likes
            $likes_stmt = $pdo->prepare("SELECT COUNT(*) FROM likes WHERE post_id = :feed_id");
            $likes_stmt->execute(['feed_id' => $feed_id]);
            $row['total_likes'] = (int)$likes_stmt->fetchColumn();
  $row = array_map('castTypes', $row);
            $data[] = $row;
        }

        echo json_encode([
            "status" => "success",
            "data" => $data,
            "pagination" => [
                "page" => $page,
                "limit" => $limit,
                "totalData" => (int)$total,
                "pages" => ceil($total / $limit)
            ]
        ]);
    } else {
        echo json_encode(["status" => "success", "data" => [], "message" => "No reels found."]);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "An error occurred", "error" => $e->getMessage()]);
}
?>
