<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
require_once 'db.php'; // Include your PDO DB connection
require_once 'castHelper.php'; 
try {
    // Allow only GET method
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Only GET method is allowed"]);
        exit;
    }

    // Check if reels_id is provided
    if (!isset($_GET['reels_id']) || empty($_GET['reels_id'])) {
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "Missing or invalid reels_id"]);
        exit;
    }

    $reelsId = $_GET['reels_id'];

    // Fetch the reel with user info
    $sql = "SELECT f.*, u.name, u.userName, u.profile_url
            FROM reels f
            LEFT JOIN users u ON u.user_id = f.user_id
            WHERE f.reels_id = :reels_id
            LIMIT 1";

    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':reels_id', $reelsId, PDO::PARAM_STR);
    $stmt->execute();

    if ($stmt->rowCount() === 0) {
        echo json_encode(["status" => "error", "message" => "Reel not found"]);
        exit;
    }

    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    // Fetch total comments
    $comments_stmt = $pdo->prepare("SELECT * FROM feed_comments WHERE feed_id = :feed_id");
    $comments_stmt->execute(['feed_id' => $reelsId]);
    $comments = $comments_stmt->fetchAll(PDO::FETCH_ASSOC);
    $row['total_comments'] = count($comments);
   

    // Fetch total likes
    $likes_stmt = $pdo->prepare("SELECT COUNT(*) FROM likes WHERE post_id = :post_id");
    $likes_stmt->execute(['post_id' => $reelsId]);
    $row['total_likes'] = (int)$likes_stmt->fetchColumn();

    $row = array_map('castTypes', $row);
    echo json_encode([
        "status" => "success",
        "data" => $row
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "An error occurred",
        "error" => $e->getMessage()
    ]);
}
?>
