<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

require_once 'db.php'; // DB connection
require_once 'function.php'; // generateLessionId()

$allowedTypes = ['image/jpeg', 'image/png', 'image/jpg', 'application/pdf'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve and sanitize input
    $course_id = $_POST['course_id'] ?? null;
    $title = $_POST['title'] ?? null;
    $contents = $_POST['contents'] ?? null;
    $status = $_POST['status'] ?? 1;
    $created_at = date("Y-m-d H:i:s");
    $updated_at = date("Y-m-d H:i:s");

    // Generate lesson ID
    $lession_id = generateLessionId($pdo);

    // Validation
    if (!$course_id || !$title || !$contents) {
        echo json_encode(["success" => false, "message" => "All fields are required"]);
        exit;
    }

    try {
        // Insert lesson
        $stmt = $pdo->prepare("INSERT INTO `lessions`(`lession_id`, `course_id`, `title`, `contents`, `status`, `created_at`, `updated_at`) 
                               VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$lession_id, $course_id, $title, $contents, $status, $created_at, $updated_at]);

        $uploadLogs = [];
        if (!empty($_FILES['file_urls']['name'][0])) {
            $fileStmt = $pdo->prepare("INSERT INTO `courses_file_url`(`fileurl_id`, `lession_id`, `file_type`, `file_urls`, `status`, `created_at`, `updated_at`) 
                                       VALUES (?, ?, ?, ?, ?, ?, ?)");
            $uploadDir = 'uploads/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            foreach ($_FILES['file_urls']['name'] as $key => $fileName) {
                $fileTmpName = $_FILES['file_urls']['tmp_name'][$key];
                $fileType = $_FILES['file_urls']['type'][$key];
                $fileError = $_FILES['file_urls']['error'][$key];

                if ($fileError !== UPLOAD_ERR_OK) {
                    $uploadLogs[] = "Upload error for file: $fileName (Error Code: $fileError)";
                    continue;
                }

                if (in_array($fileType, $allowedTypes)) {
                    $uniqueFileName = uniqid() . '_' . basename($fileName);
                    $filePath = $uploadDir . $uniqueFileName;

                    if (move_uploaded_file($fileTmpName, $filePath)) {
                        $fileurl_id = substr(uniqid(), -8);
                        $fileTypeColumn = (strpos($fileType, 'image/') === 0) ? 'image' : 'pdf';

                        $fileStmt->execute([
                            $fileurl_id,
                            $lession_id,
                            $fileTypeColumn,
                            $filePath,
                            1,
                            $created_at,
                            $updated_at
                        ]);

                        $uploadLogs[] = "Uploaded: $fileName";
                    } else {
                        $uploadLogs[] = "Failed to move uploaded file: $fileName";
                    }
                } else {
                    $uploadLogs[] = "Invalid file type: $fileName ($fileType)";
                }
            }
        } else {
            $uploadLogs[] = "No files were uploaded.";
        }

        echo json_encode([
            "status" => 'success',
            "message" => "Lesson created successfully",
            "upload_logs" => $uploadLogs
        ]);
    } catch (Exception $e) {
        echo json_encode(["status" => 'error', "message" => "Database error: " . $e->getMessage()]);
    }
} else {
    echo json_encode(["status" => 'error', "message" => "Invalid request method"]);
}
?>
