<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["error" => "Invalid request method. Only POST is allowed."]);
    exit;
}

require_once 'db.php';          // Your DB connection file ($pdo)
require_once 'function.php';    // Any custom functions if needed

$action = $_POST['action'];
$user_id = $_POST['user_id'];
$post_id = $_POST['post_id'];
$like_id = uniqid('like_', true); // Generate a unique like ID

// Input validation
if (!$user_id || !$post_id || !in_array($action, ['like', 'unlike'])) {
    echo json_encode(['error' => 'Invalid input']);
    exit;
}

try {
    if ($action === 'like') {
        $sql = "INSERT IGNORE INTO likes (like_id, user_id, post_id) VALUES (?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$like_id, $user_id, $post_id]);

        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => true, 'message' => 'Post liked']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Already liked']);
        }

    } elseif ($action === 'unlike') {
        $sql = "DELETE FROM likes WHERE user_id = ? AND post_id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$user_id, $post_id]);

        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => true, 'message' => 'Post unliked']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Not liked yet']);
        }
    }
} catch (Exception $e) {
    echo json_encode(['error' => 'Something went wrong', 'details' => $e->getMessage()]);
}
?>
