<?php
// Include database connection
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
require_once 'db.php'; // Include DB connection
require_once 'function.php'; // Include Function

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check for required POST fields
    if (
        !empty($_POST['faculty_id']) &&
        !empty($_POST['semester_id']) &&
        !empty($_POST['home_show_cate']) &&
        !empty($_POST['title']) &&
        !empty($_POST['contents']) &&
        !empty($_POST['type']) &&
        !empty($_POST['price']) &&
        !empty($_POST['status'])
    ) {
        $thumbnailPath = null;

        // Handle thumbnail file upload
        if (isset($_FILES['thumnel_url']) && $_FILES['thumnel_url']['error'] === UPLOAD_ERR_OK) {
            $targetDir = "uploads/";
            $fileName = basename($_FILES['thumnel_url']['name']);
            $targetFilePath = $targetDir . $fileName;

            if (!is_dir($targetDir)) {
                mkdir($targetDir, 0777, true);
            }

            if (move_uploaded_file($_FILES['thumnel_url']['tmp_name'], $targetFilePath)) {
                $thumbnailPath = $targetFilePath;
            }
        }

        // Generate unique IDs
        $note_id = uniqid('NOTE_');
        $id = null; // Use NULL for auto-increment if applicable

        $query = "INSERT INTO `notes` (`note_id`, `faculty_id`, `semester_id`, `home_show_cate`, `title`, `contents`, `type`, `price`, `discount`, `thumnel_url`, `status`, `created_at`, `update_at`) 
                  VALUES (:note_id, :faculty_id, :semester_id, :home_show_cate, :title, :contents, :type, :price, :discount, :thumnel_url, :status, NOW(), NOW())";

        $stmt = $pdo->prepare($query);

        // Bind parameters

        $stmt->bindParam(':note_id', $note_id);
        $stmt->bindParam(':faculty_id', $_POST['faculty_id']);
        $stmt->bindParam(':semester_id', $_POST['semester_id']);
        $stmt->bindParam(':home_show_cate', $_POST['home_show_cate']);
        $stmt->bindParam(':title', $_POST['title']);
        $stmt->bindParam(':contents', $_POST['contents']);
        $stmt->bindParam(':type', $_POST['type']);
        $stmt->bindParam(':price', $_POST['price']);
        $stmt->bindParam(':discount', $_POST['discount'] ?? 0); // Default to 0 if not provided
        $stmt->bindParam(':thumnel_url', $thumbnailPath);
        $stmt->bindParam(':status', $_POST['status']);

        if ($stmt->execute()) {
            echo json_encode(["message" => "Note created successfully."]);
        } else {
            http_response_code(503);
            echo json_encode(["message" => "Failed to create note."]);
        }
    } else {
        http_response_code(400);
        echo json_encode(["message" => "Missing required fields."]);
    }
} else {
    http_response_code(405);
    echo json_encode(["message" => "Invalid request method. Only POST is allowed."]);
}
?>
