<?php
// Include database connection
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
require_once 'db.php'; // Include DB connection

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate input
    if (
        !empty($_POST['name']) &&
        isset($_POST['status']) &&
        isset($_POST['home_title']) &&
        isset($_POST['home_status'])
    ) {
        // Generate unique category_id
        $category_id = uniqid('QCI_');

        // Set current timestamp
        $update_at = date('Y-m-d H:i:s');

        // Prepare SQL query
        $query = "INSERT INTO `quiz_category` (
                      `category_id`, `name`, `home_title`, `home_status`, `status`, `update_at`
                  ) VALUES (
                      :category_id, :name, :home_title, :home_status, :status, :update_at
                  )";

        $stmt = $pdo->prepare($query);

        // Bind parameters
        $stmt->bindParam(':category_id', $category_id);
        $stmt->bindParam(':name', $_POST['name']);
        $stmt->bindParam(':home_title', $_POST['home_title']);
        $stmt->bindParam(':home_status', $_POST['home_status']);
        $stmt->bindParam(':status', $_POST['status']);
        $stmt->bindParam(':update_at', $update_at);

        // Execute query
        if ($stmt->execute()) {
            http_response_code(201); // Created
            echo json_encode(["status" => "success", "message" => "Upload Successful"]);
        } else {
            http_response_code(503); // Service unavailable
            echo json_encode(["status" => "error", "message" => "Upload Failed"]);
        }
    } else {
        http_response_code(400); // Bad request
        echo json_encode(["message" => "Incomplete data."]);
    }
} else {
    http_response_code(405); // Method not allowed
    echo json_encode(["message" => "Invalid request method."]);
}
