<?php
// Set headers
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

// Include DB connection
require_once 'db.php';

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // Validate required fields (customize this based on your form structure)
    if (
        !empty($_POST['category_id']) &&
        !empty($_POST['title']) &&
        !empty($_POST['contents']) &&
        isset($_POST['total_points']) &&
        isset($_POST['total_question']) &&
        isset($_POST['free_paid']) &&
        isset($_POST['time_in_second']) &&
        isset($_POST['status'])
    ) {
        // Generate unique ID
        $qgc_id = uniqid('QGC_');

        // Prepare SQL insert query
        $query = "INSERT INTO `quiz_games_cate` (
            `qgc_id`, `category_id`, `title`, `contents`, `total_points`,
            `total_question`, `free_paid`, `time_in_second`, `status`,
            `created_at`, `update_at`
        ) VALUES (
            :qgc_id, :category_id, :title, :contents, :total_points,
            :total_question, :free_paid, :time_in_second, :status,
            :created_at, :update_at
        )";

        $stmt = $pdo->prepare($query);

        // Bind values
        $created_at = date('Y-m-d H:i:s');
        $update_at = $created_at;

        $stmt->bindParam(':qgc_id', $qgc_id);
        $stmt->bindParam(':category_id', $_POST['category_id']);
        $stmt->bindParam(':title', $_POST['title']);
        $stmt->bindParam(':contents', $_POST['contents']);
        $stmt->bindParam(':total_points', $_POST['total_points']);
        $stmt->bindParam(':total_question', $_POST['total_question']);
        $stmt->bindParam(':free_paid', $_POST['free_paid']);
        $stmt->bindParam(':time_in_second', $_POST['time_in_second']);
        $stmt->bindParam(':status', $_POST['status']);
        $stmt->bindParam(':created_at', $created_at);
        $stmt->bindParam(':update_at', $update_at);

        // Execute query
        if ($stmt->execute()) {
            http_response_code(201); // Created
            echo json_encode([
                "status" => "success",
                "message" => "Quiz game added successfully.",
                "qgc_id" => $qgc_id
            ]);
        } else {
            http_response_code(503); // Service unavailable
            echo json_encode(["status" => "error", "message" => "Failed to insert record."]);
        }
    } else {
        http_response_code(400); // Bad Request
        echo json_encode(["status" => "error", "message" => "Missing required fields."]);
    }
} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(["status" => "error", "message" => "Invalid request method."]);
}
?>
