<?php
// Include database connection
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

require_once 'db.php'; // Include DB connection
require_once 'function.php'; // Include Function

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate input
    if (
        !empty($_POST['faculty_id']) &&
        !empty($_POST['title']) &&
        isset($_POST['status']) &&
        !empty($_POST['number']) &&
        is_numeric($_POST['number'])
    ) {
        $faculty_id = $_POST['faculty_id'];
        $title = $_POST['title'];
        $status = $_POST['status'];
        $number = intval($_POST['number']);

        $query = "INSERT INTO `semesters`(`sem_id`, `faculty_id`, `title`, `status`, `created_at`, `updated_at`) 
                  VALUES (:sem_id, :faculty_id, :title, :status, :created_at, :updated_at)";
        $stmt = $pdo->prepare($query);

        $successCount = 0;
        $failedCount = 0;
        $sem_ids = [];

        for ($i = 1; $i <= $number; $i++) {
            $sem_id = uniqid('SEM_');
            $created_at = date('Y-m-d H:i:s');
            $updated_at = date('Y-m-d H:i:s');

            // Optionally append iteration number to title
            $title_i = $title . " " . $i;

            $stmt->bindParam(':sem_id', $sem_id);
            $stmt->bindParam(':faculty_id', $faculty_id);
            $stmt->bindParam(':title', $title_i);
            $stmt->bindParam(':status', $status);
            $stmt->bindParam(':created_at', $created_at);
            $stmt->bindParam(':updated_at', $updated_at);

            if ($stmt->execute()) {
                $successCount++;
                $sem_ids[] = $sem_id;
            } else {
                $failedCount++;
            }
        }

        http_response_code(201);
        echo json_encode([
            "status" => 'success',
            "message" => "Semester insertion complete.",
            "successful" => $successCount,
            "failed" => $failedCount,
            "sem_ids" => $sem_ids
        ]);
    } else {
        http_response_code(400); // Bad request
        echo json_encode(["message" => "Incomplete or invalid data."]);
    }
} else {
    http_response_code(405); // Method not allowed
    echo json_encode(["message" => "Invalid request method."]);
}
