
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Login</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body {
            margin: 0;
            font-family: 'Inter', Arial, sans-serif;
            background: linear-gradient(120deg, #6c63ff 0%, #4fc3f7 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .login-container {
            background: #fff;
            padding: 40px 32px;
            border-radius: 18px;
            box-shadow: 0 4px 24px rgba(0,0,0,0.09);
            max-width: 350px;
            width: 100%;
        }
        .login-title {
            text-align: center;
            font-size: 1.7rem;
            font-weight: 700;
            color: #6c63ff;
            margin-bottom: 28px;
        }
        label {
            display: block;
            margin-bottom: 6px;
            font-weight: 500;
            color: #555;
        }
        input[type="text"], input[type="password"] {
            width: 100%;
            padding: 10px 12px;
            border-radius: 8px;
            border: 1px solid #e5e9f2;
            margin-bottom: 18px;
            font-size: 1rem;
            background: #f7fbff;
            transition: border 0.2s;
        }
        input[type="text"]:focus, input[type="password"]:focus {
            border: 1.5px solid #6c63ff;
            outline: none;
        }
        .login-btn {
            width: 100%;
            background: #6c63ff;
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 12px 0;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s;
        }
        .login-btn:hover {
            background: #554ee2;
        }
        .login-footer {
            text-align: center;
            margin-top: 18px;
            color: #7b8bb2;
            font-size: 0.95rem;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-title">Admin Login</div>
        <form method="post" action="">
            <label for="username">Username</label>
            <input type="text" id="username" name="username" required autocomplete="username">

            <label for="password">Password</label>
            <input type="password" id="password" name="password" required autocomplete="current-password">

            <button type="submit" class="login-btn">Login</button>
        </form>
        <div class="login-footer">
            &copy; <?php echo date("Y"); ?> SikshaShare Admin
        </div>
    </div>
</body>
</html>