<?php
// Create global connection
$servername = "localhost";
$username = "root";
$password ="";
$db ="sikshashare";

$connect = new mysqli($servername,$username,$password,$db);
if($connect->connect_errno !=0){
    die("connection failed ".$connect->connect_errno);
}


function getDataFromDatabase($table, $columns = '*', $where = '', $params = [], $conn = null) {
    global $connect;
    if ($conn === null) {
        $conn = $connect;
    }

    $sql = "SELECT $columns FROM `$table`";
    if ($where) {
        $sql .= " WHERE $where";
    }

    $stmt = $conn->prepare($sql);
    if ($params && $stmt) {
        $types = str_repeat('s', count($params)); // assuming all params are strings
        $stmt->bind_param($types, ...$params);
    }

    $result = [];
    if ($stmt && $stmt->execute()) {
        $res = $stmt->get_result();
        while ($row = $res->fetch_assoc()) {
            $result[] = $row;
        }
        $stmt->close();
    }

    return $result;
}

function getDataFromDatabasePaging($table, $columns = '*', $where = '', $params = [], $limit = null, $offset = null, $conn = null) {
    global $connect;
    if ($conn === null) {
        $conn = $connect;
    }

    $sql = "SELECT $columns FROM `$table` ORDER BY id DESC";
    if ($where) {
        $sql .= " WHERE $where";
    }

    // Add LIMIT and OFFSET to the SQL query
    if ($limit !== null) {
        $sql .= " LIMIT ?";
        if ($offset !== null) {
            $sql .= " OFFSET ?";
        }
    }

    $stmt = $conn->prepare($sql);

    if ($stmt) {
        // Build types and bind parameters
        $types = '';
        $bindParams = [];

        if (!empty($params)) {
            $types .= str_repeat('s', count($params)); // Assume all WHERE params are strings
            $bindParams = $params;
        }

        if ($limit !== null) {
            $types .= 'i'; // LIMIT is integer
            $bindParams[] = $limit;
        }

        if ($offset !== null) {
            $types .= 'i'; // OFFSET is integer
            $bindParams[] = $offset;
        }

        if ($types && $bindParams) {
            $stmt->bind_param($types, ...$bindParams);
        }

        $result = [];
        if ($stmt->execute()) {
            $res = $stmt->get_result();
            while ($row = $res->fetch_assoc()) {
                $result[] = $row;
            }
        }

        $stmt->close();
        return $result;
    }

    return false; // Return false if preparation fails
}

function getCount($table, $conn = null) {
    global $connect;

    if ($conn === null) {
        $conn = $connect;
    }

    // Sanitize table name: allow only alphanumeric and underscore
    if (!preg_match('/^\w+$/', $table)) {
        throw new InvalidArgumentException("Invalid table name.");
    }

    $sql = "SELECT COUNT(*) as total FROM `$table`";
    $stmt = $conn->prepare($sql);

    if ($stmt && $stmt->execute()) {
        $res = $stmt->get_result();
        $row = $res->fetch_assoc();
        $stmt->close();
        return (int)$row['total'];
    }

    return 0;
}


function getWeeklyComparison($table, $dateColumn = 'created_at', $conn = null) {
    global $connect;
    if ($conn === null) {
        $conn = $connect;
    }

    // Validate table and column names to prevent SQL injection
    if (!preg_match('/^\w+$/', $table) || !preg_match('/^\w+$/', $dateColumn)) {
        throw new InvalidArgumentException("Invalid table or column name.");
    }

    $sql = "
        SELECT
            COUNT(*) AS total,
            SUM(CASE 
                WHEN `$dateColumn` >= CURDATE() - INTERVAL 7 DAY THEN 1
                ELSE 0
            END) AS this_week,
            SUM(CASE 
                WHEN `$dateColumn` >= CURDATE() - INTERVAL 14 DAY 
                     AND `$dateColumn` < CURDATE() - INTERVAL 7 DAY THEN 1
                ELSE 0
            END) AS last_week
        FROM `$table`
    ";

    $stmt = $conn->prepare($sql);
    if ($stmt && $stmt->execute()) {
        $res = $stmt->get_result();
        $data = $res->fetch_assoc();
        $stmt->close();
        return [
            'total'      => (int)$data['total'],
            'this_week'  => (int)$data['this_week'],
            'last_week'  => (int)$data['last_week']
        ];
    }

    return ['total' => 0, 'this_week' => 0, 'last_week' => 0];
}
// Example usage of the functions
// $result = getWeeklyComparison('users');
// echo "Total: " . $result['total'] . "\n";
// echo "This Week: " . $result['this_week'] . "\n";
// echo "Last Week: " . $result['last_week'] . "\n";

?>
