  <div class="dashboard-content">
      <div class="card" style="grid-column: span 2;">
          <div class="row_">
              <h2>Faculty List</h2>
              <a href="#" class="add-btn"
                  onclick="document.getElementById('addFacultyPopup').style.display='block'; return false;">Create New
                  Faculty</a>

              <!-- Popup Modal -->
              <div id="addFacultyPopup" class="popup-modal" style="display:none;">
                  <div class="popup-content">
                      <h3>Add Faculty</h3>
                      <form id="addFacultyForm" method="post" action="">
                          <label for="facultyName">Faculty Name:</label>
                          <input type="text" id="facultyName" name="title" required>
                          <label for="facultyName">Faculty Contents:</label>
                          <input type="text" id="facultyName" name="contents" required>
                          <label for="status">Status</label>
                          <select id="status" name="status" required>
                              <option value="1">Active </option>
                              <option value="0">DeActive</option>

                          </select>
                          <br><br>
                          <button type="submit" class="submit-btn">Submit</button>
                          <button type="button" class="add-btn"
                              onclick="document.getElementById('addFacultyPopup').style.display='none';">Cancel</button>
                      </form>
                  </div>
              </div>
          </div>
          <table>
              <thead>
                  <tr>
                      <th>#</th>
                      <th>title</th>
                      <th>Contents</th>
                      <th>Created</th>
                      <th>Status</th>
                      <th>Action</th>
                  </tr>
              </thead>
              <tbody>

              </tbody>
          </table>
      </div>
  </div>

  <!-- Toast CSS -->

  <div id="facultySuccessToast">Faculty added successfully!</div>


  <script>
$(document).ready(function() {
    // Function to load faculty data
    function loadFacultyTable() {
        $.ajax({
            url: '/Sikshashare/get_faculty.php',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                console.log("Received data:", data);
                var tbody = $('table tbody');
                tbody.empty();

                if (!Array.isArray(data.data) || data.data.length === 0) {
                    tbody.append('<tr><td colspan="6">No data found</td></tr>');
                    return;
                }

                data.data.forEach(function(item, index) {
                    var row = `<tr>
                    <td>${index + 1}</td>
                    <td>${item.title}</td>
                    <td>${item.contents || ''}</td>
                    <td>${item.created_at || ''}</td>
                    <td><span class='${item.status == 1 ? 'badge' : 'badge_red'}'>${item.status == 1 ? 'Active' : 'DeActive'}</span></td>
                    <td>
                        <label class="switch">
                            <input type="checkbox" class="statusToggle" data-id="${item.id}" ${item.status == 1 ? 'checked' : ''}>
                            <span class="slider round"></span>
                        </label>
                    </td>

                    <td>
                        <button class="editBtn" data-id="${item.id}">Edit</button>
                        <button class="deleteBtn" data-id="${item.id}">Delete</button>
                    </td>
                </tr>`;
                    tbody.append(row);
                });
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', status, error);
                alert('Failed to load faculty data.');
            }
        });
    }

    // Initially load table
    loadFacultyTable();

    // Attach toggle status handler
    $('.statusToggle').on('change', function() {
        var facultyId = $(this).data('id');
        var newStatus = $(this).is(':checked') ? 1 : 0;

        $.ajax({
            url: '/Sikshashare/update_faculty_status.php',
            type: 'POST',
            data: {
                id: facultyId,
                status: newStatus
            },
            success: function(response) {
                console.log('Status updated for faculty ID:', facultyId);
            },
            error: function() {
                alert('Failed to update status.');
            }
        });
    });

    // Submit form handler
    $('#addFacultyForm').on('submit', function(e) {
        e.preventDefault();

        if ($('#facultyProgressBar').length === 0) {
            $(this).append(
                '<div id="facultyProgressBar" style="margin-top:10px;"><progress style="width:100%;"></progress></div>'
            );
        }

        $('#facultyProgressBar').show();

        $.ajax({
            url: '/Sikshashare/faculty_post.php',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(res) {
                if (res.status === 'success') {
                    // Show toast
                    var toast = $('#facultySuccessToast');
                    toast.addClass('show');
                    setTimeout(function() {
                        toast.removeClass('show');
                    }, 3000);

                    $('#addFacultyPopup').hide();
                    $('#facultyProgressBar').hide();

                    // 🔁 Reload table
                    loadFacultyTable();

                    // Optional: reset the form
                    $('#addFacultyForm')[0].reset();
                } else {
                    alert(res.message || 'Error adding faculty.');
                    $('#facultyProgressBar').hide();
                }
            },
            error: function(xhr) {
                alert('Error adding faculty.');
                $('#facultyProgressBar').hide();
            }
        });
    });
});
  </script>