 <?php
 $GetData = $_GET['nid'] ?? '';
 if (empty($GetData)) { 
     header('Location: dashboard.php?page=');
     exit;
 } 
 ?>
 <div class="dashboard-content">
     <div class="card" style="grid-column: span 2;">
         <h2>Notes Create</h2>
         <?php
                // Fetch paginated semesters
                $CourseData = getDataFromDatabase('courses', '*', 'course_id = ?', [$GetData] );
                $facultyData = getDataFromDatabase('faculty', '*', 'fac_id = ?', [$CourseData[0]['fac_id']] );
                $semester = getDataFromDatabase('semesters', '*', 'sem_id = ?', [$CourseData[0]['semester_id']] );
                $courseCategory = getDataFromDatabase('course_category', '*', 'c_category_id = ?', [$CourseData[0]['c_category_id']] );
                $subjectCategory = getDataFromDatabase('subject_category', '*', 'sc_id = ?', [$CourseData[0]['subject_cid']] );
    
            ?>
         <form id="NotesFrom" method="post" action="">
             <div class="row_flex">
                 <div class="col ">
                     <label for="category">Faculty</label>
                     <select id="category" name="fac_id" onchange="getSemesterByFaculty(this.value)" required>
                         <option value=""><?php echo $facultyData[0]['title'] ?></option>
                         <?php
                            // Example static data. Replace with DB fetch in production.
                            $facultys = getDataFromDatabase('faculty', '*', '', [],);
                            foreach ($facultys as $index => $faculty) {
                                echo "<option value='{$faculty['fac_id']}'>{$faculty['title']}</option>";
                            }
                        ?>
                     </select>
                 </div>
                 <div class="col ml-3">
                     <label for="category">Semester</label>
                     <select id="semester" name="semester_id" required>
                         <option value="none"><?php echo $semester[0]['title'] ?></option>

                     </select>
                 </div>

                 <div class="col ml-3">
                     <label for="category">Subject</label>
                     <select id="category" name="subject_id" required>
                         <option value="<?php echo htmlspecialchars($subjectCategory[0]['sc_id']); ?>">
                             <?php 
                            if (!empty($subjectCategory)) {
                                echo htmlspecialchars($subjectCategory[0]['title']);
                            } else {
                                echo 'Select Subject Category';
                            }
                            ?>
                         </option>

                         <?php
                            // Example static data. Replace with DB fetch in production.
                            $facultys = getDataFromDatabase('subject_category', '*', '', [],);
                            foreach ($facultys as $index => $faculty) {
                                echo "<option value='{$faculty['sc_id']}'>{$faculty['title']}</option>";
                            }
                        ?>
                     </select>
                 </div>

                 <div class="col ml-3">
                     <label for="category">Home Show Category</label>
                     <select id="category" name="c_category_id" required>
                         <option value="none"><?php echo $courseCategory[0]['title'] ?></option>
                         <?php
                            // Example static data. Replace with DB fetch in production.
                            $facultys = getDataFromDatabase('course_category', '*', '', [],);
                            foreach ($facultys as $index => $faculty) {
                                echo "<option value='{$faculty['c_category_id']}'>{$faculty['home_title']}</option>";
                            }
                        ?>
                     </select>
                 </div>
             </div>
             <div class="row_flex">
                 <div class="col">
                     <label for="title">Notes Title</label>
                     <input type="text" id="title" name="title" value="<?php echo $CourseData[0]['title'] ?>" required>
                 </div>
             </div>
             <div class="row_flex">
                 <div class="col ">
                     <label for="category">Type</label>
                     <select id="category" name="faculty" required>
                         <option value="free">Free</option>
                         <option value="paid">Paid</option>

                     </select>
                 </div>
                 <div class="col ml-3">
                     <label for="title">Amount</label>
                     <input type="number" id="title" class="input_field" name="title" value="0" required>
                 </div>

                 <div class="col ml-3">
                     <label for="category">Status</label>
                     <select id="category" name="status" required>
                         <option value="">Select Status</option>
                         <option value="1">Active</option>
                         <option value="0">Deactive</option>

                     </select>
                 </div>
             </div>
             <div class="row_flex">
                 <div class="col ">
                     <label for="description">Images</label>
                     <input type="file" id="title" class="input_field" name="title" required>
                 </div>
             </div>
             <button type="submit" class="submit-btn">Update Save</button>
         </form>
     </div>
     <div class="card" style="grid-column: span 2;">
         <div class="row_">
             <h2>Lession List</h2>
             <a href="#" class="add-btn"
                 onclick="document.getElementById('addFacultyPopup').style.display='block'; return false;">Create New
                 Semester</a>
             <!-- Popup Modal -->
             <div id="addFacultyPopup" class="popup-modal" style="display:none;">
                 <div class="popup-content">
                     <h3>Add Semester</h3>
                     <form id="addLessionForm" method="post"  enctype="multipart/form-data">
                         </select>
                         <label for="facultyName"> Titel</label>
                         <input type="hidden" name="course_id" value="<?php echo $GetData; ?>">
                         <input type="text" id="facultyName" name="title" required>
                         <label for="facultyName">Lession Content</label>
                         <input type="text" class="input_field" id="" name="contents" required>
                         <label for="status">Status</label>
                         <select id="status" name="status" required>
                             <option value="1">Active </option>
                             <option value="0">DeActive</option>

                         </select>
                         <label for="description">Images</label>
                         <input type="file" id="title" class="input_field" name="file_urls[]" required>
                         <br><br>
                         <button type="submit" class="submit-btn">Submit</button>
                         <button type="button" class="add-btn"
                             onclick="document.getElementById('addFacultyPopup').style.display='none';">Cancel</button>
                     </form>
                 </div>
             </div>
         </div>
         <?php
                // Fetch paginated semesters
                $data = getDataFromDatabase('lessions', '*', 'course_id = ?', [$GetData] );
            ?>

         <table>
             <thead>
                 <tr>
                     <th>#</th>
                     <th>Title</th>
                     <th>Type</th>
                     <th>Contents</th>
                     <th>Status</th>
                     <th>Action</th>
                 </tr>
             </thead>
             <tbody>
                 <?php foreach ($data as $index => $datas): ?>
                 <tr>
                     <td><?= $index + 1 ?></td>
                     <td><?= htmlspecialchars($datas['title']) ?></td>
                     <td><?= htmlspecialchars($datas['course_id']) ?></td>
                     <td><?= htmlspecialchars($datas['contents']) ?></td>
                     <td><?= $datas['status'] ? 'Active' : 'Inactive' ?></td>
                     <td>
                         <a href="#" class="edit-btn">Edit</a>
                         <a href="#" class="delete-btn">Delete</a>
                     </td>
                 </tr>
                 <?php endforeach; ?>
             </tbody>
         </table>
     </div>
 </div>

<script>
function getSemesterByFaculty(facultyId) {

    console.log("Fetching semesters for faculty ID:", facultyId);

    $.ajax({
        url: '/Sikshashare/get_sem_course.php',
        type: 'GET',
        dataType: 'json',
        data: {
            faculty_id: facultyId,
            types: 'semester'
        },
        success: function(response) {

            if (response.status === 'success' && response.type === 'semesters') {
                console.log("Received semesters:", response);
                console.log("Semesters data:", response.data);

                let semesterSelect = $('select[id="semester"]');
                semesterSelect.html('<option value="">Select Semester</option>');

                response.data.forEach(semester => {
                    semesterSelect.append(
                        `<option value="${semester.sem_id}">${semester.title}</option>`);
                });
            } else {
                console.warn('Unexpected response:', response);
                let semesterSelect = $('select[id="semester"]');
                semesterSelect.html('<option value="">Select Semester</option>');
            }
        },
        error: function(xhr, status, error) {
            console.error("Error fetching semesters:", error);
        }
    });
}

// send form data to server
$(document).ready(function() {
    $('#NotesFrom').on('submit', function(event) {
        event.preventDefault(); // Prevent default form submission

        var formData = new FormData(this); // Create FormData object

        $.ajax({
            url: '/Sikshashare/notes_create.php',
            type: 'POST',
            data: formData,
            contentType: false, // Important for file uploads
            processData: false, // Important for file uploads
            success: function(response) {
                console.log("Response from server:", response);
                if (response.status === 'success') {
                    alert('Notes created successfully!');
                    // Optionally, redirect or reset the form
                } else {
                    alert('Error creating notes: ' + response.message);
                }
            },
            error: function(xhr, status, error) {
                console.error("Error in AJAX request:", error);
                alert('An error occurred while creating notes.');
            }
        });
    });
    
    $('#addLessionForm').on('submit', function(event) {
        event.preventDefault(); // Prevent default form submission

        var formData = new FormData(this); // Create FormData object

        $.ajax({
            url: '/Sikshashare/lessions_post.php',
            type: 'POST',
            data: formData,
            contentType: false, // Important for file uploads
            processData: false, // Important for file uploads
            success: function(response) {
                console.log("Response from server:", response);
                if (response.status === 'success') {
                    alert('created successfully!');
                    // Optionally, redirect or reset the form
                } else {
                    alert('Error creating notes: ' + response.message);
                }
            },
            error: function(xhr, status, error) {
                console.error("Error in AJAX request:", error);
                alert('An error occurred while creating notes.');
            }
        });
    });
});
 </script>