<div class="dashboard-content">
    <div class="card" style="grid-column: span 2;">
        <h2>Enrolled User</h2>
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>UserID</th>
                    <th>Category</th>
                    <th>type</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                // Example static data. Replace with DB fetch in production.
                $quizzes = [
                    [
                        'title' => 'What is the capital of France?',
                        'description' => 'Choose the correct capital city.',
                        'category' => 'General',
                        'options' => ['Paris', 'London', 'Berlin', 'Madrid'],
                        'answer' => 'Paris'
                    ],
                    [
                        'title' => '2 + 2 = ?',
                        'description' => 'Simple math question.',
                        'category' => 'Math',
                        'options' => ['3', '4', '5', '6'],
                        'answer' => '4'
                    ],
                    [
                        'title' => 'Who invented the telephone?',
                        'description' => 'Identify the inventor.',
                        'category' => 'History',
                        'options' => ['Edison', 'Bell', 'Newton', 'Tesla'],
                        'answer' => 'Bell'
                    ]
                ];

                // Paging setup
                $perPage = 5;
                $total = count($quizzes);
                $totalPages = ceil($total / $perPage);
                $page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
                $start = ($page - 1) * $perPage;
                $pagedQuizzes = array_slice($quizzes, $start, $perPage);

                $i = $start + 1;
                foreach ($pagedQuizzes as $quiz) {
                    echo "<tr>";
                    echo "<td>{$i}</td>";
                    echo "<td>{$quiz['title']}</td>";
                    echo "<td>{$quiz['description']}</td>";
                    echo "<td><span class='badge'>{$quiz['category']}</span></td>";
                    echo "<td><b>" . htmlspecialchars($quiz['answer']) . "</b></td>";
                    echo "<td></td>";
                    echo "</tr>";
                    $i++;
                }
                ?>
            </tbody>
        </table>
        <div style="margin-top:10px;">
            <?php
            // Paging links
            for ($p = 1; $p <= $totalPages; $p++) {
                if ($p == $page) {
                    echo "<strong>$p</strong> ";
                } else {
                    echo "<a href='?page=$p'>$p</a> ";
                }
            }
            ?>
        </div>
    </div>
</div>