<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["error" => "Invalid request method. Only POST is allowed."]);
    exit;
}

// Include your DB connection (PDO instance should be named $pdo)
require_once 'db.php';

// Validate required fields
if (

    empty($_POST['title']) ||
    empty($_POST['status'])
) {
    echo json_encode(["error" => "All fields are required (title, status)."]);
    exit;
}

// Prepare values
$sc_id = uniqid('SC_');
$title = htmlspecialchars($_POST['title']);
$status = htmlspecialchars($_POST['status']);
$created_at = date('Y-m-d H:i:s');
$updated_at = date('Y-m-d H:i:s');

// Prepare SQL statement
$sql = "INSERT INTO subject_category (sc_id, title, status, created_at, updated_at)
        VALUES (?, ?, ?, ?, ?)";
$stmt = $pdo->prepare($sql);

// Execute and return response
try {
    if ($stmt->execute([$sc_id, $title, $status, $created_at, $updated_at])) {
        echo json_encode([
            "status" => 'success',
            "message" => "Subject category inserted successfully."
        ]);
    } else {
        echo json_encode(["error" => "Failed to insert subject category."]);
    }
} catch (PDOException $e) {
    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
}
?>
